<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (
        empty($data["AdminLink"]) &&
        empty($data["AddLink"]) &&
        empty($data["RoomLink"]) &&
        empty($data["JoinLink"]) &&
        empty($data["DiamondLink"])
    ) {
        echo json_encode([
            "status" => "error",
            "message" => "At least one link is required"
        ]);
        exit;
    }

    $AdminLink   = trim($data["AdminLink"] ?? '');
    $AddLink     = trim($data["AddLink"] ?? '');
    $RoomLink    = trim($data["RoomLink"] ?? '');
    $JoinLink    = trim($data["JoinLink"] ?? '');
    $DiamondLink = trim($data["DiamondLink"] ?? '');

    $sql = "INSERT INTO `link`
            (`id`, `AdminLink`, `AddLink`, `RoomLink`, `JoinLink`, `DiamondLink`)
            VALUES (1, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                `AdminLink` = VALUES(`AdminLink`),
                `AddLink` = VALUES(`AddLink`),
                `RoomLink` = VALUES(`RoomLink`),
                `JoinLink` = VALUES(`JoinLink`),
                `DiamondLink` = VALUES(`DiamondLink`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "sssss",
        $AdminLink,
        $AddLink,
        $RoomLink,
        $JoinLink,
        $DiamondLink
    );

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Links saved successfully"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed"
        ]);
    }

    $stmt->close();
}

/* ================= GET ================= */

else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `link` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "AdminLink"   => $row["AdminLink"],
            "AddLink"     => $row["AddLink"],
            "RoomLink"    => $row["RoomLink"],
            "JoinLink"    => $row["JoinLink"],
            "DiamondLink" => $row["DiamondLink"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No data found"
        ]);
    }
}

$conn->close();
?>